// last modified by ki n 05/04/13
number exposure	= 1		// sec
number binning  = 1
number Time     = 0.5	// pre-exposure delay time in sec (60 ticks = 1 sec)
number fs 		= 12    // focus step in nm (instede of DAC)
number ni      	= 20	// number of images
string folder, name, projectName		// ### added by ki
number nmPerDAC			// ### added by ki
number startDefocus = 0;	// ### added by ki
number defocusOffset = 0;	// ### added by ki 05/04/13
number centerDefocus = 0;	// ### added by ky 08/06/03
//number top = 0, left = 0, bottom = 2048/binning, right = 2048/binning
number top = 0, left = 0, bottom, right
number isSetup = 0;
number is2byte = 0;
String group = "FSR";

// ### Get camera sizes
SSCGetSize(right, bottom)	// (width, height)

//if (!GetNumber("Number of images: ",20, ni)) exit (0)
//if (!GetNumber("Focal Step (+ve towards overfocus) (nm): ",12, fs)) exit (0)
//if (!GetNumber("Exposure time (s): ",1, exposure)) exit (0)
// ### Get necessary parameters from Global Tags
// ### exposure, binning, time, fs, ni, nmPerDAC, folder, dataName, startDefocus
{
	TagGroup tag = GetPersistentTagGroup();
	Number   succeed;
	succeed = tag.TagGroupGetTagAsTagGroup( group, tag );
	if ( !succeed ) Exit( 0 );
	succeed = tag.TagGroupGetTagAsTagGroup( "Acquisition", tag );
	if ( !succeed ) Exit( 0 );

	tag.TagGroupGetTagAsString( "name", name );
	tag.TagGroupGetTagAsNumber( "exposure", exposure );
	tag.TagGroupGetTagAsNumber( "defocueOffset", defocusOffset );
	tag.TagGroupGetTagAsNumber( "centerDefocus", centerDefocus );
	tag.TagGroupGetTagAsNumber( "fs", fs );
	tag.TagGroupGetTagAsNumber( "ni", ni );
	tag.TagGroupGetTagAsNumber( "isSetup", isSetup );
	tag.TagGroupGetTagAsNumber( "is2byte", is2byte );
	tag.TagGroupGetTagAsString( "folder", folder );
	tag.TagGroupGetTagAsNumber( "nmPerDAC", nmPerDAC );
	tag.TagGroupGetTagAsNumber( "time", time );
	tag.TagGroupGetTagAsNumber( "binning", binning );
}

projectName = folder + name;
bottom /= binning; right /= binning
fs /= nmPerDAC
Time *= 60

number focus = (centerDefocus-defocusOffset)/nmPerDAC;
number n,n1
image newimage
image img3D
imagedisplay disp3D
number width, height
focus += -fs*ni/2
EMChangeFocus(focus)
for (n=1; n<=ni; n++)
{
        delay(Time)		// ### moved by ki
        newimage := SSCGainNormalizedBinnedAcquire(exposure,binning,top, left, bottom, right)
        if ( is2byte ) {
                newimage.ConvertToShort();
        }
        if ( isSetup ) {
                if ( !img3D.ImageIsValid() ) {
                        number type = newimage.GetDataType();
                        newimage.GetSize(width, height);
                        img3D := NewImage(name, type, width, height, ni);
                        img3D.ShowImage();
                        disp3D = img3D.ImageGetImageDisplay(0);
                }
                img3D[0, 0, n-1, width, height, n] = newimage;
                disp3D.ImageDisplaySetDisplayedLayers(n-1, n-1);
                img3D.UpdateImage();
        } else {
                showImage( newimage )
        }
        n1 = n+100
        saveAsGatan(newimage, projectName + "\\image" + n1 + ".dm3")	// ### change to save in the specified folder
        //delay(Time)	// ### moved by ki
        Result("Image" + n1 + ", focus: "+ (focus * nmPerDAC)+"\n")
        if (GetKey() == 27)
        {
                Result("Image acquisition aborted, original settings restored\n")
                OkDialog("Image acquisition aborted, original settings restored")
                EMChangeFocus(-focus)
                exit(0)
        }
  EMChangeFocus( fs);
  focus += fs;
}
EMChangeFocus(-focus)
newimage := SSCGainNormalizedBinnedAcquire(exposure,binning,top, left, bottom, right)
showImage( newimage )
saveAsGatan(newimage, projectName + "\\imagefinal")		// ### change to save in the specified folder

if ( isSetup ) {
        // Acquire Images command searchs the stacked image from the front most image.
        img3D.ShowImage();
}

Exit( 1 ); // succeed
